/*
 * Decompiled with CFR 0.152.
 */
package wolforce.utils.stacks;

import java.util.Arrays;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import wolforce.utils.stacks.TagStack;

public class UtilInventory {
    public static boolean hasRequiredStacks(Player player, Object[] ingredients) {
        for (Object object : ingredients) {
            if (object instanceof TagStack) {
                TagStack tagStack = (TagStack)object;
                ItemStack[] arr = (ItemStack[])Arrays.stream(tagStack.stacks).map(s -> new ItemStack((ItemLike)s.m_41720_(), tagStack.count)).toArray(ItemStack[]::new);
                if (!UtilInventory.hasOneOfRequiredStacks(player, arr)) {
                    return false;
                }
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)object;
            if (UtilInventory.hasOneOfRequiredStacks(player, stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOneOfRequiredStacks(Player player, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (!UtilInventory.hasRequiredStack(player, stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRequiredStack(Player player, ItemStack stack) {
        return player.m_150109_().m_18947_(stack.m_41720_()) >= stack.m_41613_();
    }

    public static void removeRequiredStacks(Player player, Object[] ingredients) {
        for (Object object : ingredients) {
            if (object instanceof TagStack) {
                TagStack tagStack = (TagStack)object;
                ItemStack[] arr = (ItemStack[])Arrays.stream(tagStack.stacks).map(s -> new ItemStack((ItemLike)s.m_41720_(), tagStack.count)).toArray(ItemStack[]::new);
                UtilInventory.removeOneOfRequiredStacks(player, arr);
            }
            if (!(object instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)object;
            UtilInventory.removeOneOfRequiredStacks(player, stack);
        }
    }

    public static void removeOneOfRequiredStacks(Player player, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (!UtilInventory.hasRequiredStack(player, stack)) continue;
            UtilInventory.removeRequiredStack(player, stack);
            return;
        }
    }

    public static void removeRequiredStack(Player player, ItemStack stack) {
        int i = stack.m_41613_();
        for (int maxTimes = 1000; i > 0 && maxTimes > 0; --i, --maxTimes) {
            int slot = player.m_150109_().m_36030_(stack);
            player.m_150109_().m_7407_(slot, 1);
        }
    }
}

